(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5768,        240]*)
(*NotebookOutlinePosition[      6608,        267]*)
(*  CellTagsIndexPosition[      6564,        263]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Collocation\ method\ for\ Example\ 2.2  .1, \n\t
      taking\ tilde\[Psi]3[x] = c1\  + \ c2\ x\  + c3\ x^2\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[s/\((s^2 + x^2)\), \ {s, \ 0, 1}] // Simplify\)], "Input"],

Cell[BoxData[
    \(1\/2\ \((\(-Log[x\^2]\) + Log[1 + x\^2])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[s^2/\((s^2 + x^2)\), \ {s, \ 0, 1}]\)], "Input"],

Cell[BoxData[
    \(1 - x\ ArcTan[1\/x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[s^3/\((s^2 + x^2)\), {s, \ 0, 1}] // Simplify\)], "Input"],

Cell[BoxData[
    \(1\/2\ \((1 + x\^2\ Log[x\^2] - x\^2\ Log[1 + x\^2])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[s^4/\((s^2 + x^2)\), \ {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(1\/3 - x\^2 + x\^3\ ArcTan[1\/x]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ Note\n\t\t\[Psi]0[x] = f[x], \ 
      \[Psi]1[x] = \[Phi]1 - Integral\ of\ \((k*\[Phi]1)\)\ ds, \n
      \[Psi]2[x] = \[Phi]2 - Integral\ of\ \((k*\[Phi]2)\)\ ds, \n\t
      \[Psi]3[x] = \[Phi]3 - Integral\ of\ \((k*\[Phi]3)\)\ ds\ \ *) \n\t\t\n
    \[Psi]0[x_] := \(-x\)\ ArcTan[1/x]; \n\[Psi]1[x_] := x\ ArcTan[1\/x]; \n
    \[Psi]2[x_] := \ 
      x - 1\/2\ \((1 + x\^2\ Log[x\^2] - x\^2\ Log[1 + x\^2])\); \n
    \[Psi]3[x_] := \ 2\ x^2 - 1\/3 - x\^3\ ArcTan[1\/x]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]1[0] = Limit[\[Psi]1[x], \ x -> \ 0]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]2[0] = Limit[\[Psi]2[x], \ x\  -> \ 0]\)], "Input"],

Cell[BoxData[
    \(\(-\(1\/2\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]3[0] = Limit[\[Psi]3[x], \ x\  -> \ 0]\)], "Input"],

Cell[BoxData[
    \(\(-\(1\/3\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]1[1/2]\)], "Input"],

Cell[BoxData[
    \(ArcTan[2]\/2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]2[1/2] // Simplify\)], "Input"],

Cell[BoxData[
    \(Log[5]\/8\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]3[1/2]\)], "Input"],

Cell[BoxData[
    \(1\/6 - ArcTan[2]\/8\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]1[1]\)], "Input"],

Cell[BoxData[
    \(\[Pi]\/4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]2[1]\)], "Input"],

Cell[BoxData[
    \(1 + 1\/2\ \((\(-1\) + Log[2])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]3[1]\)], "Input"],

Cell[BoxData[
    \(5\/3 - \[Pi]\/4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = {\ {0, \ \(-1\)/2, \ \(-1\)/3}, \ \n
        \t\t{ArcTan[2]\/2, Log[5]\/8, 1\/6 - ArcTan[2]\/8}, \n
        \t\t{\[Pi]\/4, \ 1\/2\ \((1 + Log[2])\), 5\/3 - \[Pi]\/4}\ }\)], 
  "Input"],

Cell[BoxData[
    \({{0, \(-\(1\/2\)\), \(-\(1\/3\)\)}, {ArcTan[2]\/2, Log[5]\/8, 
        1\/6 - ArcTan[2]\/8}, {\[Pi]\/4, 1\/2\ \((1 + Log[2])\), 
        5\/3 - \[Pi]\/4}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]0[0] = Limit[\[Psi]0[x], \ x -> \ 0]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = {0, \ \[Psi]0[1/2], \ \[Psi]0[1]}\)], "Input"],

Cell[BoxData[
    \({0, \(-\(ArcTan[2]\/2\)\), \(-\(\[Pi]\/4\)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[a, b]\)], "Input"],

Cell[BoxData[
    \({\(-1\), 0, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Thus, \ tilde\[Psi]3[x] = \(-1\)\ \ *) \nDet[a]\)\)], "Input"],

Cell[BoxData[
    \(\(-\(\[Pi]\/48\)\) + ArcTan[2]\/3 - 3\/64\ \[Pi]\ ArcTan[2] - 
      1\/12\ ArcTan[2]\ Log[2] + 1\/96\ \[Pi]\ Log[5]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(0.129275933693824773`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{Automatic, 70}, {34, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 152, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[1886, 55, 88, 1, 27, "Input"],
Cell[1977, 58, 76, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2090, 64, 78, 1, 27, "Input"],
Cell[2171, 67, 53, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2261, 73, 88, 1, 27, "Input"],
Cell[2352, 76, 87, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2476, 82, 76, 1, 27, "Input"],
Cell[2555, 85, 66, 1, 42, "Output"]
}, Open  ]],
Cell[2636, 89, 512, 8, 208, "Input"],

Cell[CellGroupData[{
Cell[3173, 101, 75, 1, 27, "Input"],
Cell[3251, 104, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3323, 110, 77, 1, 27, "Input"],
Cell[3403, 113, 47, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3487, 119, 77, 1, 27, "Input"],
Cell[3567, 122, 47, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3651, 128, 45, 1, 27, "Input"],
Cell[3699, 131, 46, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3782, 137, 57, 1, 27, "Input"],
Cell[3842, 140, 43, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3922, 146, 45, 1, 27, "Input"],
Cell[3970, 149, 53, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4060, 155, 43, 1, 27, "Input"],
Cell[4106, 158, 42, 1, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4185, 164, 43, 1, 27, "Input"],
Cell[4231, 167, 65, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4333, 173, 43, 1, 27, "Input"],
Cell[4379, 176, 49, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4465, 182, 208, 4, 96, "Input"],
Cell[4676, 188, 188, 3, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4901, 196, 75, 1, 27, "Input"],
Cell[4979, 199, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5051, 205, 70, 1, 27, "Input"],
Cell[5124, 208, 79, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5240, 214, 50, 1, 27, "Input"],
Cell[5293, 217, 48, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5378, 223, 89, 1, 43, "Input"],
Cell[5470, 226, 150, 2, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5657, 233, 37, 1, 27, "Input"],
Cell[5697, 236, 55, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

